<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  
  xmlns:dsig="http://www.w3.org/2000/09/xmldsig#" 
  xmlns:s="http://schemas.xmlsoap.org/soap/envelope/"  
  xmlns:po="urn:po-processor">
<xsl:template match="/">
  <html>
  <body bgcolor="#FFFFCC" TEXT="#rrggbb">
    <h2>Table of Purchases:</h2>
    <table border="1">
    <tr bgcolor="#CCFFCC">
        <th align="center">Product Name</th>
        <th align="center">Quantity</th>
        <th align="center">Price</th>
        <th align="center">Ship Date</th>
        <th align="center">Comment</th>
     </tr>
     <xsl:for-each select="s:Envelope/s:Body/po:purchaseOrder/po:items/po:item">
        <tr>
          <td><xsl:value-of select="po:productName"/></td>
          <td align="center"><xsl:value-of select="po:quantity"/></td>
          <td><xsl:value-of select="po:price"/></td>
          <td align="center"><xsl:value-of select="po:shipDate"/></td>
          <td><xsl:value-of select="po:comment"/></td>
        </tr>
     </xsl:for-each>
    </table>
    <br></br>
    <xsl:choose>
      <xsl:when test="(/s:Envelope/s:Body/dsig:Signature/dsig:KeyInfo[count(*) > 0])">
        <b>
          <xsl:text>This content is signed by: </xsl:text>
          <xsl:value-of select="/s:Envelope/s:Body/dsig:Signature/dsig:KeyInfo/dsig:X509Data/dsig:X509SubjectName" />
        </b>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>This content has not been signed yet.</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </body>
  </html>
</xsl:template>
</xsl:stylesheet>
