//===========================================================================
//
// Copyright (c)  2019 Entrust.  All rights reserved.
//
//===========================================================================

package com.entrust.toolkit.examples.cms;


import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;

/**
 * Helper class which is just a wrapper that simply removes the "Message-Id" Mime component
 * that Entrust Entelligence Security Provider inserts.
 */
public class EncodeCustomMimeHeaders extends MimeMessage {

    public EncodeCustomMimeHeaders(Session session) {
        super(session);
    }

    protected void updateMessageID() throws MessagingException {
        removeHeader("Message-Id");
    }
}