//===========================================================================
//
// Copyright (c)  2002-2010 Entrust.  All rights reserved.
// 
//===========================================================================

package com.entrust.toolkit.examples.serverLogin;

import java.io.FileInputStream;
import java.io.FileOutputStream;

import com.entrust.toolkit.User;
import com.entrust.toolkit.credentials.CredentialReader;
import com.entrust.toolkit.credentials.FilenameProfileReader;
import com.entrust.toolkit.credentials.FilenameProfileWriter;
import com.entrust.toolkit.credentials.UALCreator;
import com.entrust.toolkit.credentials.UALCredentialReader;
import com.entrust.toolkit.util.SecureStringBuffer;

/******************************************************************************
* This class demonstrates server login ual binding and login.
*/
public class ServerLoginExample
{
    static private String ini = null;
    static private String profile = null;
    static private String ual = null;
    static private SecureStringBuffer password = null;

    public static void main( String[] argv )
    {
        if ( argv.length != 4  )
        {
            System.out.println("Usage: ServerLoginExample <ini> <epf> <ual> <password>");
        }

        ini = argv[0];
        profile = argv[1];
        ual = argv[2];
        password = new SecureStringBuffer(new StringBuffer(argv[3]));

        bind();
        login();
    }

    private static void bind()
    {
        try
        {
            System.out.println();
            System.out.println("binding...");
            System.out.println("Entrust ini file : " + ini );
            System.out.println("user's profile   : " + profile );
            System.out.println("user's password  : " + password.toString() );
            System.out.println("ual file         : " + ual );

            UALCreator creator = new UALCreator( ini, profile, password );
            //this is another way to create a UALCreator
            /*UALCreator creator = new UALCreator( new FilenameProfileReader( profile ),
                                                password );
            creator.setConnections( ini );*/

            FileOutputStream fos = new FileOutputStream( ual );

            long begin = System.currentTimeMillis();
            creator.bind(fos);
            long end = System.currentTimeMillis();

            System.out.println("Done. UAL binding is successful.");
            System.out.println( "time elapsed in millisecond : " + (end-begin) );

        }
        catch( Exception ex )
        {
            ex.printStackTrace();
        }
    }

    private static void login()
    {
        try
        {
            System.out.println();
            System.out.println("logging in...");
            System.out.println("user's profile : " + profile );
            System.out.println("ual file       : " + ual );

            User user = new User();
            user.setConnections(ini);

            // we might want to do a key update, so set the credential writer
            FilenameProfileWriter writer = new FilenameProfileWriter( profile, 0 );
            user.setCredentialWriter( writer );

            CredentialReader credReader = new FilenameProfileReader( profile );
            FileInputStream fis = new FileInputStream( ual );

            // set the updated ual file name to the original ual file
            // so the ual file will be updated if needed.
            UALCredentialReader reader = new UALCredentialReader( credReader, fis, ual );

            long begin = System.currentTimeMillis();
            int status = user.login( reader, null );
            long end = System.currentTimeMillis();

            System.out.println( "Done. Server login is successful: status=" + status);
            System.out.println( "time elapsed in millisecond : " + (end-begin) );
        }
        catch( Exception ex )
        {
            ex.printStackTrace();
        }
    }
}
