//===========================================================================
//
// Copyright (c)  2001-2010 Entrust.  All rights reserved.
// 
//===========================================================================

package com.entrust.toolkit.examples.ssltunneling;

import com.entrust.toolkit.User;
import com.entrust.toolkit.credentials.FilenameProfileReader;
import com.entrust.toolkit.security.provider.Initializer;
import com.entrust.toolkit.util.HttpsDirectoryClient;
import com.entrust.toolkit.util.HttpsManagerClient;
import com.entrust.toolkit.util.ManagerTransport;
import com.entrust.toolkit.util.SecureStringBuffer;
import com.entrust.toolkit.x509.LdapDirectory;

/**
 * This is the sample program for SSL tunneling.
 * <p>
 * From a client point of view, the only difference from tunneling is that the
 * user connects to HttpsManagerClient and HttpsDirectoryServlet. The rest is
 * the same.
 * <p>
 * But before running the example, you need to first set up the directory servlet
 * and manager servlet. The process is the same as for regular tunneling.
 * See the Java doc for
 * <code>com.entrust.toolkit.util.HttpDirectoryServlet</code> and
 * <code>com.entrust.toolkit.util.HttpManagerServlet</code>.
 * <p>
 * Then you need to reconfigure the WEB server to enable SSL. The
 * reconfiguration process varies depending on the WEB server you're using.
 */
public class SSLTunnelSample {
    // Edit the following settings to point to your setup.
    private static final String managerServletURL =  "https://myserver:443/tunneling/mainManager";
    private static final String directoryServletURL = "https://myserver:443/tunneling/mainDirectory";

    public static void main( String[] argv )
    {
        // Set any required security providers.
        Initializer.getInstance().setProviders(Initializer.MODE_NORMAL);

        Login();
    }

    public static void Login()
    {
        try {
            // Edit these to supply the correct epf file and password.
            SecureStringBuffer password = new SecureStringBuffer("Passw0rd");
            String epf = "user.epf";

            User user = new User();

            //  Connect to the infrastructure through SSL proxy servlets.
            ManagerTransport transport = new HttpsManagerClient(managerServletURL, 0);
            LdapDirectory directory =  new HttpsDirectoryClient(directoryServletURL, 0);

            user.setConnections(directory, transport);

            FilenameProfileReader reader = new FilenameProfileReader( epf );

            //  Login the user.
            user.login(reader, password);

            //  We're done.
            System.out.println("User login successful.");

            user.logout();

        } catch (Exception ex) {
            //  If a problem occurred, let's see what it was.
            ex.printStackTrace();
        }
    }

}
