//===========================================================================
//
// Copyright (c)  2001-2010 Entrust.  All rights reserved.
//
//===========================================================================

package com.entrust.toolkit.examples.transactionCounting;

import com.entrust.toolkit.examples.pkcs7.Decode;
import com.entrust.toolkit.examples.pkcs7.Encode;
import com.entrust.toolkit.util.TransactionCounter;
import com.entrust.toolkit.LoginCounter;
import com.entrust.toolkit.PKCS7Counter;
import java.io.*;

public class TransactionCounting
{
    private static String password = "~Sample7~";

    //change the following paths to point to the correct locations of the input files
    private static String profile = "data/userdata/RSAUser1.epf";
    private static String inputFile = "data/testfiles/test.txt";

    //change the paths to where you want the output files to be located
    private static String encryptedFile = "encrypted.out";
    private static String decryptedFile = "decrypted.out";

    public static void main(String[] argv) throws Exception
    {
        //get the counter
        TransactionCounter counter = TransactionCounter.getInstance();

        //specify the counters corresponding to the transactions desired
        counter.registerCounter(LoginCounter.getInstance());
        counter.registerCounter(PKCS7Counter.getInstance());

        //set the mode
        counter.setCountingMode( true );

        if ( counter.isOn() )
        {
            System.out.println( "Counter is on\n" );
        }
        else
        {
            System.out.println( "Counter is off\n" );
        }

        System.out.println( "*****before any transaction has performed*****\n" );
        System.out.println( counter.toString() );

        testPKCS7();

        System.out.println( "*****after some transactions have performed*****\n" );
        System.out.println( TransactionCounter.getInstance().toString() );
    }

    private static void testPKCS7()
    {
        String[] argv = new String[4];
        argv[0] = profile;
        argv[1] = password;
        argv[2] = inputFile;
        argv[3] = encryptedFile;
        Encode.main( argv );

        argv[2] = encryptedFile;
        argv[3] = decryptedFile;
        Decode.main( argv );
    }

}