//===========================================================================
//
// Copyright (c)  2001-2010 Entrust.  All rights reserved.
// 
//===========================================================================

package com.entrust.toolkit.examples.tunneling;

import com.entrust.toolkit.User;
import com.entrust.toolkit.credentials.CredentialCreator;
import com.entrust.toolkit.credentials.CredentialReader;
import com.entrust.toolkit.credentials.CredentialRecoverer;
import com.entrust.toolkit.credentials.FilenameProfileWriter;
import com.entrust.toolkit.util.AuthorizationCode;
import com.entrust.toolkit.util.HttpDirectoryClient;
import com.entrust.toolkit.util.HttpManagerClient;
import com.entrust.toolkit.util.ManagerTransport;
import com.entrust.toolkit.util.SecureStringBuffer;
import com.entrust.toolkit.x509.LdapDirectory;

/**
 * Sample to show how to create or recover credentials by tunneling the
 * LDAP and PKIX-CMP communication over HTTP.
 */
public class CreateCredentialByHttpTunnel {
    public static void main(String[] args) {
        System.out.println();
        System.out.println("CreateCredentialByHttpTunnel - Creates or recovers a user.");
        System.out.println();

        //  Check that command-line arguments were provided.
        if (args.length != 7) {
            System.out.println("Usage:  CreateCredentialByHttpTunnel <create|recover> <manager proxy URL> <directory proxy URL> <refno> <authcode> <epf name> <epf password>");
            System.out.println();
            return;
        }
        
        try {
            //  Extract all of the command-line arguments.
            int index = 0;
            String createRecover = args[index++];
            boolean create;
            if( createRecover.equalsIgnoreCase("create"))
            {
                create = true;
            }
            else
            {
                create = false;
            }

            String managerServletURL = args[index++];     // e.g. "http://appserver.domain.com:8080/servlet/mainManager" 
            String directoryServletURL = args[index++];   // e.g. "http://appserver.domain.com:8080/servlet/mainDirectory" 
            SecureStringBuffer refNo = new SecureStringBuffer(new StringBuffer(args[index++]));
            AuthorizationCode authCode = new AuthorizationCode(new StringBuffer(args[index++]));
            String epf = args[index++];
            SecureStringBuffer password = new SecureStringBuffer(new StringBuffer(args[index++]));
            
            //  Create or recover the user.
            CredentialReader creator = null;
          
            if( create )
            {
                creator = new CredentialCreator(refNo, authCode);
            }
            else
            {
                creator = new CredentialRecoverer(refNo, authCode);
            }
            User user = new User();
            
            //  Connect to the infrastructure through proxy servlets.
            ManagerTransport transport = new HttpManagerClient(managerServletURL, 0);
            LdapDirectory directory =  new HttpDirectoryClient(directoryServletURL, 0);
            user.setConnections(directory, transport);
            
            //  Create a profile writer.
            FilenameProfileWriter writer = new FilenameProfileWriter(epf);
            user.setCredentialWriter(writer);
            
            System.out.println("User create/recover begins");
            
            //  Create or recover the user.
            user.login(creator, password);
            
            //  We're done.
            System.out.println("User creation/recovery successful.");

        } catch (Exception ex) {
            //  If a problem occurred, let's see what it was.
            ex.printStackTrace();
        }
    }
}