//===========================================================================
//
// Copyright (c)  2000-2024 Entrust.  All rights reserved.
//
//===========================================================================

package com.entrust.toolkit.examples.ldaps;

import java.security.SecureRandom;

import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;

import com.entrust.toolkit.x509.directory.EntrustSSLSocketFactory;
import com.entrust.toolkit.x509.directory.LDAPSTrustManager;

/**
 * Sample class which creates a custom SSLSocketFactory to enable
 * anonymous LDAP over SSL by extending the EntrustSSLSocketFactory.   
 * 
 */

public class AnonymousSSLSocketFactory extends EntrustSSLSocketFactory {

	/**
	 * Define constructor and pass to super class
	 * @param tms The TrustManagers
	 * @param kms the KeyManager
	 * @param sr the SecureRandom
	 */
	public AnonymousSSLSocketFactory(TrustManager[] tms, KeyManager[] kms,
			SecureRandom sr) {
		super(tms, kms, sr);
	}
	
	/**
	 * Overload the getDefault() method by using the default LDAPSTrustManager.
	 * The default LDAPSTrustManager allows anonymous LDAPS connection which 
	 * means chain validation will not be performed. 
	 * 
	 * @return The socketFactory configured with the default LDAPSTrustManager
	 */
	public static SocketFactory getDefault() {
		//Setup LDAPSTrustManager to be anonymous
    	LDAPSTrustManager tm = new LDAPSTrustManager();
    	
      return new EntrustSSLSocketFactory(new TrustManager[] { tm}, null, new java.security.SecureRandom() );
    }


}