//===========================================================================
//
// Copyright (c)  2018-2024 Entrust.  All rights reserved.
// 
//===========================================================================
package com.entrust.toolkit.examples.smproxy;

import com.entrust.toolkit.User;
import com.entrust.toolkit.credentials.FilenameProfileReader;
import com.entrust.toolkit.util.SecureStringBuffer;

/**
 * Demonstrates using SMProxy with configuration settings in an entrust.ini file.
 * 
 * <p> NOTE: if all of the connections are through the same SMProxy host, use
 * SMProxyURL=&lt;smproxy host&gt; in the INI file.  Otherwise, any of the following
 * settings will override the general setting:
 * <li>SMManagerProxyURL=  The SMProxy URL for Manager connections</li>
 * <li>SMServerProxyURL=  The SMProxy URL for LDAP directory connections</li>
 * <li>SMRoamingProxyURL=  The SMProxy URL for Roaming connections</li>
 * 
 * <p>
 * SMProxyCompatibilityMode - Setting this value to "true" limits the TLS 
 * protocol version to 1.0 for backwards compatibility with old SMProxy servers.  
 * You can also use the system property <code>com.entrust.toolkit.smproxy.compat</code>
 * 
 *
 */
public class ImplicitConfig {

	/**
	 * @param args
	 */
	public static void main(String[] args) {

        // Ensure that the required command-line arguments were provided
        if (args.length != 3) {
            System.out.println("\nImplicitConfig - Login using implicitly configured SMProxy connections");
            System.out.println(
                "\nUsage:  java ImplicitConfig <INI file> <epf name> <password>\n");
            return;
        }

        // Create the user
        System.out.print("Login User... ");
        try {

            //  Extract all of the command-line arguments.
            int index = 0;
            String iniFile = args[index++];
            String epf = args[index++];
            SecureStringBuffer securePassword = new SecureStringBuffer(new StringBuffer(args[index++]));
            
			User user = new User();
			user.setConnections(iniFile);
			
			FilenameProfileReader credentialReader = new FilenameProfileReader(epf);
	
			user.login(credentialReader,securePassword);
			
	        System.out.println("Done");
	        
	        user.logout();
			
        }
        catch(Exception ex) {
        	ex.printStackTrace();
        }
	}
}
