//===========================================================================
//
// Copyright (c)  2001-2024 Entrust.  All rights reserved.
// 
//===========================================================================

package com.entrust.toolkit.examples.ssl.multithread;

import java.io.*;

/**
 * This class is part of the multithreading example. It is used from the classes Client and Server.
 *
 * @see Server
 * @see Client
 */
public class Feeder extends Thread {

  private OutputStream os;
  private Throwable error;
  private boolean active = true;
  private int count = 0;

  public Feeder(OutputStream outStream, String name) {
    super(name);
    os = outStream;
    error = null;
  }

  public void setActive(boolean active) {
    this.active = active;
  }

  public int getCount() {
    return count;
  }

  public void run() {
    try {
      int counter = 0;
      while( active ) {
        os.write(counter++);
        count++;
        os.flush();
        counter &= 0xff;
        sleep(10);
      }
    } catch( Throwable e ) {
      error = e;
    } finally {
      active = false;
      try{os.close();}
      catch(IOException e){/*do nothing*/}
    }
  }

  void checkError() throws Throwable {
    if( error != null ) {
      throw error;
    }
  }
}
