//===========================================================================
//
// Copyright (c)  2003-2010 Entrust.  All rights reserved.
// 
//===========================================================================

package com.entrust.toolkit.examples.crypto;

import iaik.utils.Util;

import java.security.SecureRandom;

import com.entrust.toolkit.security.provider.Initializer;

/**
 * This example demonstrates how to use Entrust's 'FIPS186_2' implementation 
 * of a Secure Random algorithm from the Java Cryptography Architecture (JCA).
 * 
 * <p>
 * It shows how to use the FIPS186_2 secure random algorithm to generate
 * pseudo-random numbers.
 * </p>
 * 
 * <p>
 * The JCA refers to a framework for accessing and developing cryptographic 
 * functionality for the Java platform.  For further information on how the JCA
 * is used, please refer to Java's 
 * <a href=http://download.oracle.com/javase/1.5.0/docs/guide/security/index.html>
 * Security Documentation</a> documentation.
 * </p>
 */
public class SecureRandomExampleFIPS186_2 {

    /**
     * The main program.
     * <p></p>
     * 
     * @param args
     *      not used
     */
    public static void main(String[] args) {

        // Ensure that Entrust's providers have been installed
        System.out.print("Installing providers... ");
        Initializer.getInstance().setProviders(Initializer.MODE_NORMAL);
        System.out.println("DONE");
        System.out.println();

        try {
            // Request an instance of the FIPS186_2 secure random algorithm from 
            // the Entrust provider
            SecureRandom secureRandom = SecureRandom.getInstance("FIPS186_2", "Entrust");

            // Generate some random data
            System.out.print("Generating random data... ");
            byte[] randomData = new byte[10];
            secureRandom.nextBytes(randomData);
            System.out.println("DONE");
            System.out.println("random data: " + Util.toString(randomData));
            System.out.println();

            // Generate some more random data
            System.out.print("Generating more random data... ");
            secureRandom.nextBytes(randomData);            
            System.out.println("DONE");
            System.out.println("random data: " + Util.toString(randomData));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}