//===========================================================================
//
// Copyright (c)  2018 Entrust Datacard Corporation.  All rights reserved.
// 
//===========================================================================
package com.entrust.toolkit.examples.smproxy;

import java.net.URL;

import com.entrust.toolkit.User;
import com.entrust.toolkit.credentials.FilenameProfileReader;
import com.entrust.toolkit.credentials.FilenameProfileWriter;
import com.entrust.toolkit.smproxy.SMProxyConfig;
import com.entrust.toolkit.util.SMProxyManagerTransport;
import com.entrust.toolkit.util.SecureStringBuffer;
import com.entrust.toolkit.x509.directory.SMProxyDirectory;

/**
 *  This example demonstrates using SMProxy with explicit parameters.  It also 
 *  uses SSL to connect to the SMProxy server.
 * 
 */
public class ExplicitConfig {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		
        // Ensure that the required command-line arguments were provided
        if (args.length != 3) {
            System.out.println("\nExplicitConfig - Login using explicitly configured SMProxy connections");
            System.out.println(
                "\nUsage:  java ExplicitConfig <epf name> <password> <proxy URL>\n");
            System.out.println(
                    "\nExample:  java ExplicitConfig johnsmith.epf jul1ets1erra! http://proxyserver\n");
            return;
        }

        // Optional: Enable Entrust toolkit logging
        //System.setProperty("com.entrust.toolkit.trace", "4");
        
        // Optional: Enable JSSE logging
        //System.setProperty("javax.net.debug", "all");
        
		 try {
            //  Extract all of the command-line arguments.
            int index = 0;
            String epf = args[index++];
            SecureStringBuffer securePassword = new SecureStringBuffer(new StringBuffer(args[index++]));
            URL proxyServerURL = new URL(args[index++]);

            System.out.print("Login User offline... ");

            // Create a temporary user object to be used for the SSL 
            // connection to the SMProxy server
			User offlineUser = new User();
			
			// Construct a credential reader and writer
			FilenameProfileReader credentialReader = new FilenameProfileReader(epf);
			FilenameProfileWriter credentialWriter = new FilenameProfileWriter(epf);

			// Optional:  If using an SMProxy server version prior to 7.0 and
			// TLS will be used for the connection, set compatibility mode to 
			// true to force TLS 1.0
			SMProxyConfig.setCompatMode(true);
						
			offlineUser.login(credentialReader, securePassword);
			System.out.println("Done");
			
			// Use config constructor which provides TLS credentials
			SMProxyConfig config = new SMProxyConfig(offlineUser);
			
			// Setup the directory connection
			SMProxyDirectory directory = new SMProxyDirectory(proxyServerURL);
			directory.setSoConnectionTimeout(10000);
			directory.setSearchTimeout(30000);
			directory.setSMProxyConfig(config);
			
			// Setup the manager transport connection
			SMProxyManagerTransport managerTransport = new SMProxyManagerTransport(proxyServerURL);
			managerTransport.setSMProxyConfig(config);
			managerTransport.setSoConnectTimeout(10000);
			managerTransport.setSoTimeout(30000);
			
			// Create the full user object
			User user = new User();

			// Add connections to the user object
			user.setConnections(directory, managerTransport);
			
			user.setCredentialWriter(credentialWriter);
			
	        System.out.print("Login online user... ");
        
	        // Perform the online login
			user.login(credentialReader,securePassword);
			System.out.println("Done");
			System.out.println("User status: " + user.getStatus().toString());
			
			user.logout();
			 
		} catch (Exception e) {
			e.printStackTrace();
		} 
	}
}
