//===========================================================================
//
// Copyright (c)  2018 Entrust Datacard Corporation.  All rights reserved.
// 
//===========================================================================
package com.entrust.toolkit.examples.smproxy;

import com.entrust.toolkit.User;
import com.entrust.toolkit.credentials.FilenameProfileReader;
import com.entrust.toolkit.smproxy.ProxyOrder;
import com.entrust.toolkit.util.ManagerTransportWithSMProxy;
import com.entrust.toolkit.util.SecureStringBuffer;
import com.entrust.toolkit.x509.directory.JNDIWithSMProxy;

/**
 * @author gmorse
 *
 */
public class UserLoginWithProxyOrder {

	/**
	 * @param args
	 */
	public static void main(String[] args) {

        // Ensure that the required command-line arguments were provided
        if (args.length != 3) {
            System.out.println("\nProxyOrder - Login using implicitly configured SMProxy connections");
            System.out.println(
                "\nUsage:  java ProxyOrder <INI file> <epf name> <password>\n");
            return;
        }

        // Create the user
        System.out.print("Login User... ");
        try {

            //  Extract all of the command-line arguments.
            int index = 0;
            String iniFile = args[index++];
            String epf = args[index++];
            SecureStringBuffer securePassword = new SecureStringBuffer(new StringBuffer(args[index++]));
            
            // Set the proxy order
            ProxyOrder proxyOrder = ProxyOrder.PROXYFIRST;
            			
			// Create an Ldap Directory connection that will attempt to use the proxy first.
			JNDIWithSMProxy directory = new JNDIWithSMProxy(iniFile, proxyOrder);
			
			// Create a Manager Transport that will attempt to use the proxy first.
			ManagerTransportWithSMProxy managerTransport = new ManagerTransportWithSMProxy(iniFile, proxyOrder);
			
			// Create the user object and set the connections			
			User user = new User();
			user.setConnections(directory, managerTransport);
			
			// Setup the credential reader
			// If this is a roaming user, you can use the proxy order method shown in the SMProxy Roaming sample.
			FilenameProfileReader credentialReader = new FilenameProfileReader(epf);
			
	
			// Login
			user.login(credentialReader,securePassword);
			
	        System.out.println("Done");
	        
	        user.logout();
			
        }
        catch(Exception ex) {
        	ex.printStackTrace();
        }
	}
}
