//===========================================================================
//
// Copyright (c)  2001-2010 Entrust.  All rights reserved.
// 
//===========================================================================

package com.entrust.toolkit.examples.ssl.multithread;

import java.io.*;

/**
 * This class is part of the multithreading example. It is used from the classes Client and Server.
 *
 * @see Server
 * @see Client
 */
public class Reader extends Thread {

  private InputStream is;
  private Throwable error;
  private boolean active = true;
  private int count = 0;

  public Reader(InputStream inStream, String name) {
    super(name);
    is = inStream;
    error = null;
  }

  public void setActive(boolean active) {
    this.active = active;
  }

  public int getCount() {
    return count;
  }

  public void run() {
    try {
      int counter = 0;
      while( active ) {
        int b = is.read();
        if( b == -1 ) {
          throw new RuntimeException("Read EOF, terminating");
        }
        count++;
        if( b != counter ) {
          throw new RuntimeException("Data error: " + b + " != " + counter);
        }
        counter++;
        counter &= 0xff;
      }
    } catch( Throwable e ) {
      error = e;
    } finally {
      active = false;
      try{is.close();}
      catch(IOException e){/*do nothing*/}
    }
  }

  void checkError() throws Throwable {
    if( error != null ) {
      throw error;
    }
  }
}
