//===========================================================================
//
// Copyright (c)  2001-2010 Entrust.  All rights reserved.
// 
//===========================================================================

package com.entrust.toolkit.examples.tunneling;

import iaik.utils.Util;

import com.entrust.toolkit.User;
import com.entrust.toolkit.credentials.CredentialCreator;
import com.entrust.toolkit.credentials.FilenameProfileWriter;
import com.entrust.toolkit.util.AuthorizationCode;
import com.entrust.toolkit.util.HttpDirectoryClient;
import com.entrust.toolkit.util.HttpManagerClient;
import com.entrust.toolkit.util.SecureStringBuffer;

/******************************************************************************
* This class tests proxied HTTP tunneling with HTTP header support.
* It connects the manager and the directory through a proxy. The manager and
* the directory are protected by user id and password.
*/
public class CreateCredentialByProxiedHttpTunnel {
    public static void main(String[] args) {
        try {
            //  Check that command-line arguments were provided.
            if (args.length != 8) {
                System.out.println();
                System.out.println("CreateCredentialByProxiedHttpTunnel - Creates a new user.");
                System.out.println();
                System.out.println("Usage: CreateCredentialByProxiedHttpTunnel <manager proxy URL> <directory proxy URL> <refno> <authcode> <webProxyIp> <webProxyPort> <epf name> <epf password>");
                System.out.println();
                return;
            }

            //  Extract all of the command-line arguments.
            int index = 0;
            String managerServletURL = args[index++];     // e.g. "http://appserver.domain.com:8080/servlet/mainManager" 
            String directoryServletURL = args[index++];   // e.g. "http://appserver.domain.com:8080/servlet/mainDirectory" 
            SecureStringBuffer refNo = new SecureStringBuffer(new StringBuffer(args[index++]));
            AuthorizationCode authCode = new AuthorizationCode(new StringBuffer(args[index++]));
            String webproxyIp = args[index++];
            String webproxyPort = args[index++];
            String epf = args[index++];
            SecureStringBuffer password = new SecureStringBuffer(new StringBuffer(args[index++]));

            System.out.println("managerServletURL" +managerServletURL);
            System.out.println("directoryServletURL" +directoryServletURL);
            //  Create the user.
            CredentialCreator creator = new CredentialCreator(refNo, authCode);
            User user = new User();

            //  Connect to the infrastructure through proxy servlets.
            HttpManagerClient transport = new HttpManagerClient(managerServletURL, 0);
            HttpDirectoryClient directory =  new HttpDirectoryClient(directoryServletURL, 0);

            //set the HTTP header
            String webId = "admin";
            String webPassword = "mypassword";
             
            byte[] encoded = Util.Base64Encode( (webId + ":" + webPassword).getBytes() );
            directory.addHttpHeader( "Authorization", "Basic " + new String(Util.Base64Decode(encoded)) );
            transport.addHttpHeader( "Authorization", "Basic " + new String(Util.Base64Decode(encoded)) );

            // set the proxy
            directory.setWebProxy( webproxyIp, Integer.parseInt(webproxyPort));
            transport.setWebProxy(webproxyIp, Integer.parseInt(webproxyPort));
            user.setConnections(directory, transport);
            //  Create a profile writer.
            FilenameProfileWriter writer = new FilenameProfileWriter(epf);
            user.setCredentialWriter(writer);

            //  Create the user.
            user.login(creator, password);

            //  We're done.
            System.out.println("User creation successful.");

        } catch (Exception ex) {
            //  If a problem occurred, let's see what it was.
            ex.printStackTrace();
        }
    }
}
