REM 
REM -- THIS FILE MUST BE EDITED !
REM
REM
setlocal
REM
REM -- Edit these lines to reflect your libraries' locations. Append to this classpath
REM -- all required external jar files, as described in the 'xml_decryptionTransform_readme.html'.
REM -- You'll need xercesImpl.jar, xalan.jar, and xml-apis.jar.
REM
REM -- Adjust this line to the location of the JDK
set JDK=%JAVA_HOME%
REM
REM -- Adjust this example line to the location of the Apache jar files
set XMLJARS=C:\xalan-j_2_5_0\bin
REM
REM -- 
cd ..\..\..\..\..\..\..
set SAMPLE_CLASSES=classes
set CP=%SAMPLE_CLASSES%
set CP=%CP%;..\lib\unsigned\enttoolkit.jar
REM
set CP=%CP%;%XMLJARS%\xercesImpl.jar
set CP=%CP%;%XMLJARS%\xalan.jar
set CP=%CP%;%XMLJARS%\xml-apis.jar
REM
REM -- Adjust this line to the location where you installed the Toolkit
set INIT_PROPERTIES_URL=file:/etjava/examples/data/xml/init/properties/init.properties
REM
REM -- Set the JAVA command with its classpath
set JAVAC=%JDK%\bin\javac -sourcepath source -d %SAMPLE_CLASSES% -classpath %CP%
REM
set TRACE_LEVEL=com.entrust.toolkit.xencrypt.core.TransformImplDecryption.trace=1
set JAVA_RUN=%JDK%\bin\java -D%TRACE_LEVEL% -classpath %CP%
REM
REM -- Compile source
md %SAMPLE_CLASSES%
%JAVAC% source\com\entrust\toolkit\examples\xml\decryptionTransform\*.java
%JAVAC% source\com\entrust\toolkit\examples\xml\utils\*.java
REM
REM -- Run the example
REM 
REM 1. -- Alice encrypts for herself all elements named 'ForAlice' 
REM
%JAVA_RUN% com.entrust.toolkit.examples.xml.decryptionTransform.EncryptElements data/userData/RSAUser1.epf ~Sample7~ %INIT_PROPERTIES_URL% data/xml/decryptionTransform/decryptionTransformSample.xml encrypted.xml ForAlice 
pause
REM 
REM 2. -- Alice signs the document, an enveloped signature with a Decryption Transform
REM 
%JAVA_RUN% com.entrust.toolkit.examples.xml.decryptionTransform.SignDecryptionTransform data/userdata/RSAUser1.epf ~Sample7~ %INIT_PROPERTIES_URL% file:encrypted.xml DecryptTransformSigned.xml PutSignatureHere "ancestor-or-self::SignThis and not(ancestor-or-self::DoNotSignThis)"
pause
REM
REM 3. -- Alice encrypts for Bob all elements named 'ForBob' 
REM 
%JAVA_RUN% com.entrust.toolkit.examples.xml.decryptionTransform.EncryptElements data/userdata/RSAUser1.epf ~Sample7~ %INIT_PROPERTIES_URL% DecryptTransformSigned.xml DecryptTransformSigned.xml ForBob -cert data\userdata\RSAUser2Encryption.cer 
pause
REM 
REM 4. -- Super encryption -- Alice again encrypts for Bob the previously encrypted content 
REM 
%JAVA_RUN% com.entrust.toolkit.examples.xml.decryptionTransform.EncryptElements data/userdata/RSAUser1.epf ~Sample7~ %INIT_PROPERTIES_URL% DecryptTransformSigned.xml DecryptTransformSigned.xml Super -cert data\userdata\RSAUser2Encryption.cer 
pause
REM
REM 5. -- Bob verifies the signature.  The trace shows that two decryptions must be performed before the signature is verified.
REM
%JAVA_RUN% com.entrust.toolkit.examples.xml.decryptionTransform.VerifyDecryptionTransform data/userdata/RSAUser2.epf ~Sample7~ %INIT_PROPERTIES_URL% file:DecryptTransformSigned.xml
pause
REM
REM 6. -- Alice cannot verify the signature (the signed content was encrypted for Bob)
REM
REM %JAVA_RUN% com.entrust.toolkit.examples.xml.decryptionTransform.VerifyDecryptionTransform data/userdata/RSAUser1.epf ~Sample7~ %INIT_PROPERTIES_URL% file:DecryptTransformSigned.xml
REM
REM -- Return to original sample folder, required only if setlocal/endlocal is removed from this script
cd source\com\entrust\toolkit\examples\xml\decryptionTransform
endlocal
